; SN76498A.s

	.module SN76489A
	
	; global from this code
    ; void write_sn76489A_register (byte i);
	.globl _write_sn76489A_register

	; void write_sample_sn76489A_all_3 (byte i);    
	.globl _write_sample_sn76489A_all_3		; method 1
	
	; void write_sample_sn76489A_1 (byte i);
	; void write_sample_sn76489A_2 (byte i);	
	; void write_sample_sn76489A_3 (byte i);	
	.globl _write_sample_sn76489A_1			; method 2
	.globl _write_sample_sn76489A_2
	.globl _write_sample_sn76489A_3
		
	; void sound_play_sample_dpcm(unsigned char delay,unsigned char *address,int length);
	.globl _sound_play_sample_dpcm
	
    ; void sound_delay (void);		
	.globl _sound_delay						; delay method
	
	; void sound_sample_delay(void);
	.globl _sound_sample_delay

	.area _CODE
	
_write_sn76489A_register:
	ld iy,#2
    add iy,sp 	;Bypass the return address of the function

	ld a,(iy)  ; byte
	out (0xFF),a
    ret

_write_sample_sn76489A_1:
	ld iy,#2
    add iy,sp 	;Bypass the return address of the function

	ld a,(iy)  ; byte
	xor a,#0x0F
	or a,#0x90
	out (0xFF),a
    ret

_write_sample_sn76489A_2:
	ld iy,#2
    add iy,sp 	;Bypass the return address of the function

	ld a,(iy)  ; byte
	xor a,#0x0F
	or a,#0xB0
	out (0xFF),a
    ret

_write_sample_sn76489A_3:
	ld iy,#2
    add iy,sp 	;Bypass the return address of the function

	ld a,(iy)  ; byte
	xor a,#0x0F
	or a,#0xD0
	out (0xFF),a	
    ret

_write_sample_sn76489A_all_3:
	ld iy,#2
    add iy,sp 	;Bypass the return address of the function

	ld a,(iy)  ; byte

_sound_sample_output:
	xor a,#0x0F
	or a,#0x90
	out (0xFF),a
	add a,#0x20	
	out (0xFF),a
	add a,#0x20
	out (0xFF),a
    ret
        	
;=-=-=-=- Playing 2bit differential PCM samples =-=-=-=-=
_sound_play_sample_dpcm:
	ld  iy,#2
    add iy,sp 	;Bypass the return address of the function
    
    ld  e,(iy)	;Contains the delay counter
	
	; The address of the sample.
    ld l,1(iy)   ;address (low)
    ld h,2(iy)   ;address (high)
    
    ; The length of the sample.
    ld c,3(iy)	 ;length (low)
    ld b,4(iy)	 ;length (high).
    
    ; initial sample.
    ld a,(hl)
	inc hl
	dec bc
	
	; save it
    push af
	call _sound_sample_output
	call _sound_delay

$next_dpcm:	
	ld a,(hl)
	inc hl
	dec bc
	ld d,a			; keep it in d for now
	
	ex	af,af'
	ld a,#4
	ex af,af'

$dpcm_step:
	and a,#0x03
	cp  #1
	jr  z,$is1
	cp  #2
	jr  z,$is2
	cp  #3
	jr  z,$is3
$is0:
	pop af
	; no change
	jr $doit
$is1:
	pop af
	; + 1
	inc a
	jr $doit
$is2:
	pop af
	; + 2
	inc a
	inc a
	jr $doit
$is3:
	pop af
	; - 1
	dec a
$doit:
	push af			; save it again
	call _sound_sample_output
	call _sound_delay
	
	ld a,d
	rra
	rra
	ld d,a
	
	ex af,af'
	dec a
	jr z,$next_dcmq
	
	ex af,af'
	jr $dpcm_step
	
$next_dcmq:
	ex af,af'
	
	ld  a,c				;		 4
	or  a,b				;        4

	jr  z,$done			;		 7
			
	jr $next_dpcm	

$done:
	pop af	; get rid of the buffered sample on stack
	ret

;=-=-=-=-=-=-=-=-=- delay functions =-=-=-=-=-=-=-=-=-=-=-=-
_sound_delay:
	ld    a,e			;  4 cycles

$domore:
	nop					;  4 cycles
	dec   a				;  4 cycles
	or    a				;  4 cycles
	jr    nz,$domore	; 12 cycles
	
	ret					; 10 cycles

_sound_sample_delay:

	; silence sample
	ld  a,#0x98
	out (0xFF),a		;		11
	add a,#0x20			;		 7
	out (0xFF),a		;		11 
	add a,#0x20			;		 7
	out (0xFF),a		;		11
	
	; setup delay
	ld  c,#0x00
	ld  b,#0x10

$domoredelay:		
	dec bc
	ld  a,c
	or  a,b
	jr  z,$done_wait
	
	jr  $domoredelay

$done_wait:
	ret
